using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Safecracker
{
    public partial class frmSafecracker : Form
    {
        public frmSafecracker()
        {
            InitializeComponent();
        }

        Random myRandom = new Random();
        Label[] combo = new Label[4];
        Button[] comboButton = new Button[9];
        int numberDigits;
        String secretCombo;
        int digitsEntered;
        String enteredCombo;
        System.Media.SoundPlayer wrongSound;
        System.Media.SoundPlayer correctSound;



        private void frmSafecracker_Load(object sender, EventArgs e)
        {
            // disable combination panel and setup arrays
            pnlSafe.Enabled = false;
            combo[0] = lblCombo1;
            combo[1] = lblCombo2;
            combo[2] = lblCombo3;
            combo[3] = lblCombo4;
            comboButton[0] = btn1;
            comboButton[1] = btn2;
            comboButton[2] = btn3;
            comboButton[3] = btn4;
            comboButton[4] = btn5;
            comboButton[5] = btn6;
            comboButton[6] = btn7;
            comboButton[7] = btn8;
            comboButton[8] = btn9;
            wrongSound = new System.Media.SoundPlayer(Application.StartupPath + "\\uhoh.wav");
            correctSound = new System.Media.SoundPlayer(Application.StartupPath + "\\tada.wav");
        }

        private void btnExit_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnStartStop_Click(object sender, EventArgs e)
        {
            if (btnStartStop.Text == "Start Game")
            {
                btnStartStop.Text = "Stop Game";
                grpOptions.Enabled = false;
                btnExit.Enabled = false;
                pnlSafe.Enabled = true;
                txtResults.Text = "";
                // determine number of digits and set up labels
                if (rdoTwoDigits.Checked)
                    numberDigits = 2;
                else if (rdoThreeDigits.Checked)
                    numberDigits = 3;
                else
                    numberDigits = 4;
                for (int i = 0; i < numberDigits; i++)
                {
                    combo[i].Visible = true;
                    combo[i].Text = "";
                }
                if (numberDigits != 4)
                {
                    for (int i = numberDigits; i < 4; i++)
                    {
                        combo[i].Visible = false;
                    }
                }
                // determine combination
                secretCombo = "";
                int j;
                bool uniqueDigit;
                for (int i = 0; i < numberDigits; i++)
                {
                    // select unique digit
                    do
                    {
                        j = myRandom.Next(9) + 1;
                        uniqueDigit = true;
                        if (i != 0)
                        {
                            for (int k = 0; k < i ; k++)
                            {
                                if (secretCombo[k].ToString() == j.ToString())
                                    uniqueDigit = false;
                            }
                        }
                    }
                    while (!uniqueDigit);
                    secretCombo += j.ToString();
                }
                enteredCombo = "";
                digitsEntered = 0;
            }
            else
            {
                if (enteredCombo == secretCombo)
                    txtResults.AppendText("That's it!!" + "\r\n");
                else
                    txtResults.AppendText("Game Stopped" + "\r\n");
                txtResults.AppendText("Combination: " + secretCombo);
                btnStartStop.Text = "Start Game";
                grpOptions.Enabled = true;
                btnExit.Enabled = true;
                pnlSafe.Enabled = false;
            }
        }

        private void btnCombo_Click(object sender, EventArgs e)
        {
            String n;
            int numberRight, positionRight;
            // determine which button was clicked
            Button clickedButton;
            clickedButton = (Button) sender;
            // button Text is clicked number
            n = clickedButton.Text;
            // disable button since digits can't repeat
            clickedButton.Enabled = false;
            // if first button in combo, clear out label boxes
            if (digitsEntered == 0)
            {
                combo[0].Text = "";
                combo[1].Text = "";
                combo[2].Text = "";
                combo[3].Text = "";
            }
            // add button to code
            enteredCombo += n;
            digitsEntered++;
            combo[digitsEntered - 1].Text = n;
            // if all digits entered, check combo
            if (digitsEntered == numberDigits)
            {
                // reset combo buttons
                for (int i = 0; i < 9; i++)
                    comboButton[i].Enabled = true;
                // check combination
                txtResults.AppendText("Entered: " + enteredCombo + "\r\n");
                if (enteredCombo == secretCombo)
                {
                    correctSound.Play();
                    btnStartStop.PerformClick();
                }
                else
                {
                    wrongSound.Play();
                    numberRight = 0;
                    for (int i = 0; i < numberDigits; i++)
                    {
                        n = enteredCombo[i].ToString();
                        for (int j = 0; j < numberDigits; j++)
                            if (n == secretCombo[j].ToString())
                                numberRight++;
                    }
                    // how many in correct position
                    positionRight = 0;
                    for (int i = 0; i < numberDigits; i++)
                        if (secretCombo[i] == enteredCombo[i])
                            positionRight++;
                    txtResults.AppendText(numberRight.ToString() + " digits correct" + "\r\n");
                    txtResults.AppendText(positionRight.ToString() + " in correct position" + "\r\n");
                    txtResults.AppendText("Try again ..." + "\r\n\r\n");
                    // clear combo to try again
                    enteredCombo = "";
                    digitsEntered = 0;
                }
            }
        }

    }
}